#ifdef PRECOMPUTE_TRANSMITTANCE
	layout(location = 0) out vec3 transmittance;
#endif

#ifdef PRECOMPUTE_DIRECT_IRRADIANCE
	layout(location = 0) out vec3 delta_irradiance;
    layout(location = 1) out vec3 irradiance;
 
	uniform sampler2D transmittance_texture;
#endif

#ifdef PRECOMPUTE_SINGLE_SCATTERING
	layout(location = 0) out vec3 delta_rayleigh;
    layout(location = 1) out vec3 delta_mie;
    layout(location = 2) out vec4 scattering;
    layout(location = 3) out vec3 single_mie_scattering;
    
	uniform mat3 luminance_from_radiance;
    uniform sampler2D transmittance_texture;
    uniform int layer;
#endif

#ifdef PRECOMPUTE_SCATTERING_DENSITY
	layout(location = 0) out vec3 scattering_density;
	
    uniform sampler2D transmittance_texture;
    uniform sampler3D single_rayleigh_scattering_texture;
    uniform sampler3D single_mie_scattering_texture;
    uniform sampler3D multiple_scattering_texture;
    uniform sampler2D irradiance_texture;
    uniform int scattering_order;
    uniform int layer;
#endif

#ifdef PRECOMPUTE_INDIRECT_IRRADIANCE
	layout(location = 0) out vec3 delta_irradiance;
    layout(location = 1) out vec3 irradiance;
    
	uniform mat3 luminance_from_radiance;
    uniform sampler3D single_rayleigh_scattering_texture;
    uniform sampler3D single_mie_scattering_texture;
    uniform sampler3D multiple_scattering_texture;
    uniform int scattering_order;
#endif

#ifdef PRECOMPUTE_MULTIPLE_SCATTERING
	layout(location = 0) out vec3 delta_multiple_scattering;
    layout(location = 1) out vec4 scattering;
    
	uniform mat3 luminance_from_radiance;
    uniform sampler2D transmittance_texture;
    uniform sampler3D scattering_density_texture;
    uniform int layer;
#endif

uniform vec3 mie_scattering;
uniform vec3 ray_scattering;
uniform vec3 mie_extinction;
uniform vec3 solar_irradiance;
uniform vec3 absorption_extinction;
uniform vec3 ground_albedo;

void main() 
{
	ATMOSPHERE.mie_scattering=mie_scattering;
	ATMOSPHERE.mie_extinction=mie_extinction;
	ATMOSPHERE.rayleigh_scattering=ray_scattering;
	ATMOSPHERE.absorption_extinction=absorption_extinction;
	ATMOSPHERE.ground_albedo=ground_albedo;
	ATMOSPHERE.solar_irradiance=solar_irradiance;
	
	#ifdef PRECOMPUTE_TRANSMITTANCE
		transmittance = ComputeTransmittanceToTopAtmosphereBoundaryTexture(ATMOSPHERE, gl_FragCoord.xy);
	#endif   
	
	#ifdef PRECOMPUTE_DIRECT_IRRADIANCE		
		delta_irradiance = ComputeDirectIrradianceTexture(ATMOSPHERE, transmittance_texture, gl_FragCoord.xy);
		irradiance = vec3(0.0);
	#endif
	
	#ifdef PRECOMPUTE_SINGLE_SCATTERING		
		ComputeSingleScatteringTexture(ATMOSPHERE, transmittance_texture, vec3(gl_FragCoord.xy, layer + 0.5), delta_rayleigh, delta_mie);
		scattering = vec4(luminance_from_radiance * delta_rayleigh.rgb, (luminance_from_radiance * delta_mie).r);
		single_mie_scattering = luminance_from_radiance * delta_mie;
	#endif
	
	#ifdef PRECOMPUTE_SCATTERING_DENSITY
		scattering_density = ComputeScatteringDensityTexture(
																ATMOSPHERE, transmittance_texture, single_rayleigh_scattering_texture,
																single_mie_scattering_texture, multiple_scattering_texture,
																irradiance_texture, vec3(gl_FragCoord.xy, layer + 0.5),
																scattering_order
															);
	#endif
	
	#ifdef PRECOMPUTE_INDIRECT_IRRADIANCE
		delta_irradiance = ComputeIndirectIrradianceTexture(
															ATMOSPHERE, single_rayleigh_scattering_texture,
															single_mie_scattering_texture, multiple_scattering_texture,
															gl_FragCoord.xy, scattering_order
															);
		irradiance = luminance_from_radiance * delta_irradiance;
	#endif
	
	#ifdef PRECOMPUTE_MULTIPLE_SCATTERING
		float nu;
		delta_multiple_scattering = ComputeMultipleScatteringTexture(
																		ATMOSPHERE, transmittance_texture, scattering_density_texture,
																		vec3(gl_FragCoord.xy, layer + 0.5), nu
																	);
		scattering = vec4(luminance_from_radiance * delta_multiple_scattering.rgb / RayleighPhaseFunction(nu), 0.0);
	#endif
}
